/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.neapolitan.common.block.VanillaVineTopBlock;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanCriteriaTriggers;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.PlantBlockHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;

public class VanillaVineBlock
extends Block
implements IGrowable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)};

    public VanillaVineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()];
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState otherState = worldIn.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()));
        Block block = otherState.func_177230_c();
        return VanillaVineTopBlock.facingSameDirection(state, otherState) || block.func_203417_a(NeapolitanTags.Blocks.VANILLA_PLANTABLE_ON);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Block block;
        if (facing == ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        VanillaVineTopBlock topVine = (VanillaVineTopBlock)NeapolitanBlocks.VANILLA_VINE.get();
        if (facing == stateIn.func_177229_b((Property)FACING) && (block = facingState.func_177230_c()) != this && block != topVine) {
            return (BlockState)topVine.func_176223_P().func_206870_a((Property)FACING, stateIn.func_177229_b((Property)FACING));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)NeapolitanItems.VANILLA_PODS.get());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> optional = this.nextGrowPosition(worldIn, pos, state);
        return optional.isPresent() && PlantBlockHelper.func_235514_a_((BlockState)worldIn.func_180495_p(optional.get().func_177972_a((Direction)state.func_177229_b((Property)FACING))));
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        Optional<BlockPos> optional = this.nextGrowPosition((IBlockReader)worldIn, pos, state);
        if (optional.isPresent()) {
            BlockState blockstate = worldIn.func_180495_p(optional.get());
            ((VanillaVineTopBlock)blockstate.func_177230_c()).func_225535_a_(worldIn, rand, optional.get(), blockstate);
        }
    }

    private Optional<BlockPos> nextGrowPosition(IBlockReader reader, BlockPos pos, BlockState state) {
        Block block;
        BlockPos blockpos = pos;
        while ((block = reader.func_180495_p(blockpos = blockpos.func_177972_a((Direction)state.func_177229_b((Property)FACING))).func_177230_c()) == state.func_177230_c()) {
        }
        return block == NeapolitanBlocks.VANILLA_VINE.get() ? Optional.of(blockpos) : Optional.empty();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        boolean flag = super.func_196253_a(state, useContext);
        return flag && useContext.func_195996_i().func_77973_b() == ((Block)NeapolitanBlocks.VANILLA_VINE.get()).func_199767_j() ? false : flag;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        VanillaVineBlock.createPoisonCloud(world, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public static void createPoisonCloud(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_184614_ca().func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS) && !player.field_71075_bZ.field_75098_d) {
            if (player instanceof ServerPlayerEntity) {
                NeapolitanCriteriaTriggers.VANILLA_POISON.trigger((ServerPlayerEntity)player);
            }
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
            areaeffectcloudentity.func_184496_a(new EffectInstance(new EffectInstance(Effects.field_76436_u, 300)));
            areaeffectcloudentity.func_184483_a(1.0f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            world.func_217376_c((Entity)areaeffectcloudentity);
        }
    }
}

